#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Diffraction Through 5 SlitsMod01.fsh   by     beans_please
//https://www.shadertoy.com/view/XXlBDH
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// colormap source:
// https://www.shadertoy.com/view/MfjBDV

// https://www.desmos.com/calculator/n4mfhffj1n
float colormap_expf(float x, float v)
{
    if (abs(v) < .0001) v = .0001;
    float p = pow(2., v);
    return (1. - pow(p, -x)) / (1. - 1. / p);
}

vec3 colormap(float x)
{
    float t = .18 * abs(x);
    if (x < 0.)
    {
        x = -x;
        t = -.37 - .14 * x;
    }
    
    // https://www.desmos.com/calculator/sdqk904uu9
    vec3 tone = 8. * vec3(
        cos(6.283 * t),
        cos(6.283 * (t - .3333)),
        cos(6.283 * (t - .6667))
    );
    
    x = smoothstep(0., 1., x);
    vec3 c = vec3(
        colormap_expf(x, tone.r),
        colormap_expf(x, tone.g),
        colormap_expf(x, tone.b)
    );
    
    c = mix(c, c + vec3(.04, 0, .03), smoothstep(.1, 0., x));
    
    return c;
}

float spow(float a, float b)
{
    return sign(a) * pow(abs(a), b);
}
#define frag_col fragColor
#define frag_coord fragCoord

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 uv = (2. * frag_coord - iResolution.xy) / min(iResolution.x, iResolution.y);
    
    float v = 0.;
    for (float x = -2.; x <= 2.; x++)
    {
        vec2 center = vec2(.2 * x, -.9);
        float dist = distance(uv, center);
        v += sin(100. * dist - 5. * iTime) / (dist + .05);
    }
    
    vec3 col = vec3(colormap(.05 * v));
    
    col = pow(col, vec3(1. / 2.2));
    frag_col = vec4(col, 1);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

